package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CpsUploadCertificateArgs private(
  acknowledgeChangeManagement: Output[Option[Boolean]],
  acknowledgePostVerificationWarnings: Output[Option[Boolean]],
  autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]],
  certificateEcdsaPem: Output[Option[String]],
  certificateRsaPem: Output[Option[String]],
  enrollmentId: Output[Int],
  trustChainEcdsaPem: Output[Option[String]],
  trustChainRsaPem: Output[Option[String]],
  waitForDeployment: Output[Option[Boolean]]
) derives ArgsEncoder

object CpsUploadCertificateArgs:
  def apply(
    acknowledgeChangeManagement: Input.Optional[Boolean] = None,
    acknowledgePostVerificationWarnings: Input.Optional[Boolean] = None,
    autoApproveWarnings: Input.Optional[List[Input[String]]] = None,
    certificateEcdsaPem: Input.Optional[String] = None,
    certificateRsaPem: Input.Optional[String] = None,
    enrollmentId: Input[Int],
    trustChainEcdsaPem: Input.Optional[String] = None,
    trustChainRsaPem: Input.Optional[String] = None,
    waitForDeployment: Input.Optional[Boolean] = None
  )(using Context): CpsUploadCertificateArgs =
    new CpsUploadCertificateArgs(
      acknowledgeChangeManagement = acknowledgeChangeManagement.asOptionOutput(isSecret = false),
      acknowledgePostVerificationWarnings = acknowledgePostVerificationWarnings.asOptionOutput(isSecret = false),
      autoApproveWarnings = autoApproveWarnings.asOptionOutput(isSecret = false),
      certificateEcdsaPem = certificateEcdsaPem.asOptionOutput(isSecret = false),
      certificateRsaPem = certificateRsaPem.asOptionOutput(isSecret = false),
      enrollmentId = enrollmentId.asOutput(isSecret = false),
      trustChainEcdsaPem = trustChainEcdsaPem.asOptionOutput(isSecret = false),
      trustChainRsaPem = trustChainRsaPem.asOptionOutput(isSecret = false),
      waitForDeployment = waitForDeployment.asOptionOutput(isSecret = false)
    )
