package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Datastream private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  active: Output[Boolean],
  azureConnector: Output[Option[besom.api.akamai.outputs.DatastreamAzureConnector]],
  collectMidgress: Output[Option[Boolean]],
  contractId: Output[String],
  createdBy: Output[String],
  createdDate: Output[String],
  datadogConnector: Output[Option[besom.api.akamai.outputs.DatastreamDatadogConnector]],
  datasetFields: Output[scala.collection.immutable.List[Int]],
  deliveryConfiguration: Output[besom.api.akamai.outputs.DatastreamDeliveryConfiguration],
  elasticsearchConnector: Output[Option[besom.api.akamai.outputs.DatastreamElasticsearchConnector]],
  gcsConnector: Output[Option[besom.api.akamai.outputs.DatastreamGcsConnector]],
  groupId: Output[String],
  httpsConnector: Output[Option[besom.api.akamai.outputs.DatastreamHttpsConnector]],
  latestVersion: Output[Int],
  logglyConnector: Output[Option[besom.api.akamai.outputs.DatastreamLogglyConnector]],
  modifiedBy: Output[String],
  modifiedDate: Output[String],
  newRelicConnector: Output[Option[besom.api.akamai.outputs.DatastreamNewRelicConnector]],
  notificationEmails: Output[Option[scala.collection.immutable.List[String]]],
  oracleConnector: Output[Option[besom.api.akamai.outputs.DatastreamOracleConnector]],
  papiJson: Output[String],
  productId: Output[String],
  properties: Output[scala.collection.immutable.List[String]],
  s3Connector: Output[Option[besom.api.akamai.outputs.DatastreamS3Connector]],
  splunkConnector: Output[Option[besom.api.akamai.outputs.DatastreamSplunkConnector]],
  streamName: Output[String],
  streamVersion: Output[Int],
  sumologicConnector: Output[Option[besom.api.akamai.outputs.DatastreamSumologicConnector]]
) extends CustomResource derives ResourceDecoder

object Datastream:
  given outputOps: {} with
    extension(output: Output[Datastream])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def active: Output[Boolean] = output.flatMap(_.active)
      def azureConnector: Output[Option[besom.api.akamai.outputs.DatastreamAzureConnector]] = output.flatMap(_.azureConnector)
      def collectMidgress: Output[Option[Boolean]] = output.flatMap(_.collectMidgress)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def createdBy: Output[String] = output.flatMap(_.createdBy)
      def createdDate: Output[String] = output.flatMap(_.createdDate)
      def datadogConnector: Output[Option[besom.api.akamai.outputs.DatastreamDatadogConnector]] = output.flatMap(_.datadogConnector)
      def datasetFields: Output[scala.collection.immutable.List[Int]] = output.flatMap(_.datasetFields)
      def deliveryConfiguration: Output[besom.api.akamai.outputs.DatastreamDeliveryConfiguration] = output.flatMap(_.deliveryConfiguration)
      def elasticsearchConnector: Output[Option[besom.api.akamai.outputs.DatastreamElasticsearchConnector]] = output.flatMap(_.elasticsearchConnector)
      def gcsConnector: Output[Option[besom.api.akamai.outputs.DatastreamGcsConnector]] = output.flatMap(_.gcsConnector)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def httpsConnector: Output[Option[besom.api.akamai.outputs.DatastreamHttpsConnector]] = output.flatMap(_.httpsConnector)
      def latestVersion: Output[Int] = output.flatMap(_.latestVersion)
      def logglyConnector: Output[Option[besom.api.akamai.outputs.DatastreamLogglyConnector]] = output.flatMap(_.logglyConnector)
      def modifiedBy: Output[String] = output.flatMap(_.modifiedBy)
      def modifiedDate: Output[String] = output.flatMap(_.modifiedDate)
      def newRelicConnector: Output[Option[besom.api.akamai.outputs.DatastreamNewRelicConnector]] = output.flatMap(_.newRelicConnector)
      def notificationEmails: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.notificationEmails)
      def oracleConnector: Output[Option[besom.api.akamai.outputs.DatastreamOracleConnector]] = output.flatMap(_.oracleConnector)
      def papiJson: Output[String] = output.flatMap(_.papiJson)
      def productId: Output[String] = output.flatMap(_.productId)
      def properties: Output[scala.collection.immutable.List[String]] = output.flatMap(_.properties)
      def s3Connector: Output[Option[besom.api.akamai.outputs.DatastreamS3Connector]] = output.flatMap(_.s3Connector)
      def splunkConnector: Output[Option[besom.api.akamai.outputs.DatastreamSplunkConnector]] = output.flatMap(_.splunkConnector)
      def streamName: Output[String] = output.flatMap(_.streamName)
      def streamVersion: Output[Int] = output.flatMap(_.streamVersion)
      def sumologicConnector: Output[Option[besom.api.akamai.outputs.DatastreamSumologicConnector]] = output.flatMap(_.sumologicConnector)

def datastream(using ctx: Context)(
  name: NonEmptyString,
  args: DatastreamArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Datastream] = 
  ctx.registerResource[Datastream, DatastreamArgs]("akamai:index/datastream:Datastream", name, args, opts)

