package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class DatastreamArgs private(
  active: Output[Boolean],
  azureConnector: Output[Option[besom.api.akamai.inputs.DatastreamAzureConnectorArgs]],
  collectMidgress: Output[Option[Boolean]],
  contractId: Output[String],
  datadogConnector: Output[Option[besom.api.akamai.inputs.DatastreamDatadogConnectorArgs]],
  datasetFields: Output[scala.collection.immutable.List[Int]],
  deliveryConfiguration: Output[besom.api.akamai.inputs.DatastreamDeliveryConfigurationArgs],
  elasticsearchConnector: Output[Option[besom.api.akamai.inputs.DatastreamElasticsearchConnectorArgs]],
  gcsConnector: Output[Option[besom.api.akamai.inputs.DatastreamGcsConnectorArgs]],
  groupId: Output[String],
  httpsConnector: Output[Option[besom.api.akamai.inputs.DatastreamHttpsConnectorArgs]],
  logglyConnector: Output[Option[besom.api.akamai.inputs.DatastreamLogglyConnectorArgs]],
  newRelicConnector: Output[Option[besom.api.akamai.inputs.DatastreamNewRelicConnectorArgs]],
  notificationEmails: Output[Option[scala.collection.immutable.List[String]]],
  oracleConnector: Output[Option[besom.api.akamai.inputs.DatastreamOracleConnectorArgs]],
  properties: Output[scala.collection.immutable.List[String]],
  s3Connector: Output[Option[besom.api.akamai.inputs.DatastreamS3ConnectorArgs]],
  splunkConnector: Output[Option[besom.api.akamai.inputs.DatastreamSplunkConnectorArgs]],
  streamName: Output[String],
  sumologicConnector: Output[Option[besom.api.akamai.inputs.DatastreamSumologicConnectorArgs]]
) derives ArgsEncoder

object DatastreamArgs:
  def apply(
    active: Input[Boolean],
    azureConnector: Input.Optional[besom.api.akamai.inputs.DatastreamAzureConnectorArgs] = None,
    collectMidgress: Input.Optional[Boolean] = None,
    contractId: Input[String],
    datadogConnector: Input.Optional[besom.api.akamai.inputs.DatastreamDatadogConnectorArgs] = None,
    datasetFields: Input[List[Input[Int]]],
    deliveryConfiguration: Input[besom.api.akamai.inputs.DatastreamDeliveryConfigurationArgs],
    elasticsearchConnector: Input.Optional[besom.api.akamai.inputs.DatastreamElasticsearchConnectorArgs] = None,
    gcsConnector: Input.Optional[besom.api.akamai.inputs.DatastreamGcsConnectorArgs] = None,
    groupId: Input[String],
    httpsConnector: Input.Optional[besom.api.akamai.inputs.DatastreamHttpsConnectorArgs] = None,
    logglyConnector: Input.Optional[besom.api.akamai.inputs.DatastreamLogglyConnectorArgs] = None,
    newRelicConnector: Input.Optional[besom.api.akamai.inputs.DatastreamNewRelicConnectorArgs] = None,
    notificationEmails: Input.Optional[List[Input[String]]] = None,
    oracleConnector: Input.Optional[besom.api.akamai.inputs.DatastreamOracleConnectorArgs] = None,
    properties: Input[List[Input[String]]],
    s3Connector: Input.Optional[besom.api.akamai.inputs.DatastreamS3ConnectorArgs] = None,
    splunkConnector: Input.Optional[besom.api.akamai.inputs.DatastreamSplunkConnectorArgs] = None,
    streamName: Input[String],
    sumologicConnector: Input.Optional[besom.api.akamai.inputs.DatastreamSumologicConnectorArgs] = None
  )(using Context): DatastreamArgs =
    new DatastreamArgs(
      active = active.asOutput(isSecret = false),
      azureConnector = azureConnector.asOptionOutput(isSecret = false),
      collectMidgress = collectMidgress.asOptionOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      datadogConnector = datadogConnector.asOptionOutput(isSecret = false),
      datasetFields = datasetFields.asOutput(isSecret = false),
      deliveryConfiguration = deliveryConfiguration.asOutput(isSecret = false),
      elasticsearchConnector = elasticsearchConnector.asOptionOutput(isSecret = false),
      gcsConnector = gcsConnector.asOptionOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      httpsConnector = httpsConnector.asOptionOutput(isSecret = false),
      logglyConnector = logglyConnector.asOptionOutput(isSecret = false),
      newRelicConnector = newRelicConnector.asOptionOutput(isSecret = false),
      notificationEmails = notificationEmails.asOptionOutput(isSecret = false),
      oracleConnector = oracleConnector.asOptionOutput(isSecret = false),
      properties = properties.asOutput(isSecret = false),
      s3Connector = s3Connector.asOptionOutput(isSecret = false),
      splunkConnector = splunkConnector.asOptionOutput(isSecret = false),
      streamName = streamName.asOutput(isSecret = false),
      sumologicConnector = sumologicConnector.asOptionOutput(isSecret = false)
    )
