package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class DnsRecord private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  active: Output[Option[Boolean]],
  algorithm: Output[Option[Int]],
  answerType: Output[String],
  certificate: Output[Option[String]],
  digest: Output[Option[String]],
  digestType: Output[Option[Int]],
  dnsName: Output[String],
  emailAddress: Output[Option[String]],
  expiration: Output[Option[String]],
  expiry: Output[Option[Int]],
  fingerprint: Output[Option[String]],
  fingerprintType: Output[Option[Int]],
  flags: Output[Option[Int]],
  flagsnaptr: Output[Option[String]],
  hardware: Output[Option[String]],
  inception: Output[Option[String]],
  iterations: Output[Option[Int]],
  key: Output[Option[String]],
  keytag: Output[Option[Int]],
  labels: Output[Option[Int]],
  mailbox: Output[Option[String]],
  matchType: Output[Option[Int]],
  name: Output[String],
  nameServer: Output[Option[String]],
  nextHashedOwnerName: Output[Option[String]],
  nxdomainTtl: Output[Option[Int]],
  order: Output[Option[Int]],
  originalTtl: Output[Option[Int]],
  port: Output[Option[Int]],
  preference: Output[Option[Int]],
  priority: Output[Option[Int]],
  priorityIncrement: Output[Option[Int]],
  protocol: Output[Option[Int]],
  recordSha: Output[String],
  recordtype: Output[String],
  refresh: Output[Option[Int]],
  regexp: Output[Option[String]],
  replacement: Output[Option[String]],
  retry: Output[Option[Int]],
  salt: Output[Option[String]],
  selector: Output[Option[Int]],
  serial: Output[Int],
  service: Output[Option[String]],
  signature: Output[Option[String]],
  signer: Output[Option[String]],
  software: Output[Option[String]],
  subtype: Output[Option[Int]],
  svcParams: Output[Option[String]],
  svcPriority: Output[Option[Int]],
  targetName: Output[Option[String]],
  targets: Output[Option[scala.collection.immutable.List[String]]],
  ttl: Output[Int],
  txt: Output[Option[String]],
  typeBitmaps: Output[Option[String]],
  typeCovered: Output[Option[String]],
  typeMnemonic: Output[Option[String]],
  typeValue: Output[Option[Int]],
  usage: Output[Option[Int]],
  weight: Output[Option[Int]],
  zone: Output[String]
) extends CustomResource derives ResourceDecoder

object DnsRecord:
  given outputOps: {} with
    extension(output: Output[DnsRecord])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def active: Output[Option[Boolean]] = output.flatMap(_.active)
      def algorithm: Output[Option[Int]] = output.flatMap(_.algorithm)
      def answerType: Output[String] = output.flatMap(_.answerType)
      def certificate: Output[Option[String]] = output.flatMap(_.certificate)
      def digest: Output[Option[String]] = output.flatMap(_.digest)
      def digestType: Output[Option[Int]] = output.flatMap(_.digestType)
      def dnsName: Output[String] = output.flatMap(_.dnsName)
      def emailAddress: Output[Option[String]] = output.flatMap(_.emailAddress)
      def expiration: Output[Option[String]] = output.flatMap(_.expiration)
      def expiry: Output[Option[Int]] = output.flatMap(_.expiry)
      def fingerprint: Output[Option[String]] = output.flatMap(_.fingerprint)
      def fingerprintType: Output[Option[Int]] = output.flatMap(_.fingerprintType)
      def flags: Output[Option[Int]] = output.flatMap(_.flags)
      def flagsnaptr: Output[Option[String]] = output.flatMap(_.flagsnaptr)
      def hardware: Output[Option[String]] = output.flatMap(_.hardware)
      def inception: Output[Option[String]] = output.flatMap(_.inception)
      def iterations: Output[Option[Int]] = output.flatMap(_.iterations)
      def key: Output[Option[String]] = output.flatMap(_.key)
      def keytag: Output[Option[Int]] = output.flatMap(_.keytag)
      def labels: Output[Option[Int]] = output.flatMap(_.labels)
      def mailbox: Output[Option[String]] = output.flatMap(_.mailbox)
      def matchType: Output[Option[Int]] = output.flatMap(_.matchType)
      def name: Output[String] = output.flatMap(_.name)
      def nameServer: Output[Option[String]] = output.flatMap(_.nameServer)
      def nextHashedOwnerName: Output[Option[String]] = output.flatMap(_.nextHashedOwnerName)
      def nxdomainTtl: Output[Option[Int]] = output.flatMap(_.nxdomainTtl)
      def order: Output[Option[Int]] = output.flatMap(_.order)
      def originalTtl: Output[Option[Int]] = output.flatMap(_.originalTtl)
      def port: Output[Option[Int]] = output.flatMap(_.port)
      def preference: Output[Option[Int]] = output.flatMap(_.preference)
      def priority: Output[Option[Int]] = output.flatMap(_.priority)
      def priorityIncrement: Output[Option[Int]] = output.flatMap(_.priorityIncrement)
      def protocol: Output[Option[Int]] = output.flatMap(_.protocol)
      def recordSha: Output[String] = output.flatMap(_.recordSha)
      def recordtype: Output[String] = output.flatMap(_.recordtype)
      def refresh: Output[Option[Int]] = output.flatMap(_.refresh)
      def regexp: Output[Option[String]] = output.flatMap(_.regexp)
      def replacement: Output[Option[String]] = output.flatMap(_.replacement)
      def retry: Output[Option[Int]] = output.flatMap(_.retry)
      def salt: Output[Option[String]] = output.flatMap(_.salt)
      def selector: Output[Option[Int]] = output.flatMap(_.selector)
      def serial: Output[Int] = output.flatMap(_.serial)
      def service: Output[Option[String]] = output.flatMap(_.service)
      def signature: Output[Option[String]] = output.flatMap(_.signature)
      def signer: Output[Option[String]] = output.flatMap(_.signer)
      def software: Output[Option[String]] = output.flatMap(_.software)
      def subtype: Output[Option[Int]] = output.flatMap(_.subtype)
      def svcParams: Output[Option[String]] = output.flatMap(_.svcParams)
      def svcPriority: Output[Option[Int]] = output.flatMap(_.svcPriority)
      def targetName: Output[Option[String]] = output.flatMap(_.targetName)
      def targets: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.targets)
      def ttl: Output[Int] = output.flatMap(_.ttl)
      def txt: Output[Option[String]] = output.flatMap(_.txt)
      def typeBitmaps: Output[Option[String]] = output.flatMap(_.typeBitmaps)
      def typeCovered: Output[Option[String]] = output.flatMap(_.typeCovered)
      def typeMnemonic: Output[Option[String]] = output.flatMap(_.typeMnemonic)
      def typeValue: Output[Option[Int]] = output.flatMap(_.typeValue)
      def usage: Output[Option[Int]] = output.flatMap(_.usage)
      def weight: Output[Option[Int]] = output.flatMap(_.weight)
      def zone: Output[String] = output.flatMap(_.zone)

def dnsRecord(using ctx: Context)(
  name: NonEmptyString,
  args: DnsRecordArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[DnsRecord] = 
  ctx.registerResource[DnsRecord, DnsRecordArgs]("akamai:index/dnsRecord:DnsRecord", name, args, opts)

