package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class DnsRecordArgs private(
  active: Output[Option[Boolean]],
  algorithm: Output[Option[Int]],
  certificate: Output[Option[String]],
  digest: Output[Option[String]],
  digestType: Output[Option[Int]],
  emailAddress: Output[Option[String]],
  expiration: Output[Option[String]],
  expiry: Output[Option[Int]],
  fingerprint: Output[Option[String]],
  fingerprintType: Output[Option[Int]],
  flags: Output[Option[Int]],
  flagsnaptr: Output[Option[String]],
  hardware: Output[Option[String]],
  inception: Output[Option[String]],
  iterations: Output[Option[Int]],
  key: Output[Option[String]],
  keytag: Output[Option[Int]],
  labels: Output[Option[Int]],
  mailbox: Output[Option[String]],
  matchType: Output[Option[Int]],
  name: Output[Option[String]],
  nameServer: Output[Option[String]],
  nextHashedOwnerName: Output[Option[String]],
  nxdomainTtl: Output[Option[Int]],
  order: Output[Option[Int]],
  originalTtl: Output[Option[Int]],
  port: Output[Option[Int]],
  preference: Output[Option[Int]],
  priority: Output[Option[Int]],
  priorityIncrement: Output[Option[Int]],
  protocol: Output[Option[Int]],
  recordtype: Output[String],
  refresh: Output[Option[Int]],
  regexp: Output[Option[String]],
  replacement: Output[Option[String]],
  retry: Output[Option[Int]],
  salt: Output[Option[String]],
  selector: Output[Option[Int]],
  service: Output[Option[String]],
  signature: Output[Option[String]],
  signer: Output[Option[String]],
  software: Output[Option[String]],
  subtype: Output[Option[Int]],
  svcParams: Output[Option[String]],
  svcPriority: Output[Option[Int]],
  targetName: Output[Option[String]],
  targets: Output[Option[scala.collection.immutable.List[String]]],
  ttl: Output[Int],
  txt: Output[Option[String]],
  typeBitmaps: Output[Option[String]],
  typeCovered: Output[Option[String]],
  typeMnemonic: Output[Option[String]],
  typeValue: Output[Option[Int]],
  usage: Output[Option[Int]],
  weight: Output[Option[Int]],
  zone: Output[String]
) derives ArgsEncoder

object DnsRecordArgs:
  def apply(
    active: Input.Optional[Boolean] = None,
    algorithm: Input.Optional[Int] = None,
    certificate: Input.Optional[String] = None,
    digest: Input.Optional[String] = None,
    digestType: Input.Optional[Int] = None,
    emailAddress: Input.Optional[String] = None,
    expiration: Input.Optional[String] = None,
    expiry: Input.Optional[Int] = None,
    fingerprint: Input.Optional[String] = None,
    fingerprintType: Input.Optional[Int] = None,
    flags: Input.Optional[Int] = None,
    flagsnaptr: Input.Optional[String] = None,
    hardware: Input.Optional[String] = None,
    inception: Input.Optional[String] = None,
    iterations: Input.Optional[Int] = None,
    key: Input.Optional[String] = None,
    keytag: Input.Optional[Int] = None,
    labels: Input.Optional[Int] = None,
    mailbox: Input.Optional[String] = None,
    matchType: Input.Optional[Int] = None,
    name: Input.Optional[String] = None,
    nameServer: Input.Optional[String] = None,
    nextHashedOwnerName: Input.Optional[String] = None,
    nxdomainTtl: Input.Optional[Int] = None,
    order: Input.Optional[Int] = None,
    originalTtl: Input.Optional[Int] = None,
    port: Input.Optional[Int] = None,
    preference: Input.Optional[Int] = None,
    priority: Input.Optional[Int] = None,
    priorityIncrement: Input.Optional[Int] = None,
    protocol: Input.Optional[Int] = None,
    recordtype: Input[String],
    refresh: Input.Optional[Int] = None,
    regexp: Input.Optional[String] = None,
    replacement: Input.Optional[String] = None,
    retry: Input.Optional[Int] = None,
    salt: Input.Optional[String] = None,
    selector: Input.Optional[Int] = None,
    service: Input.Optional[String] = None,
    signature: Input.Optional[String] = None,
    signer: Input.Optional[String] = None,
    software: Input.Optional[String] = None,
    subtype: Input.Optional[Int] = None,
    svcParams: Input.Optional[String] = None,
    svcPriority: Input.Optional[Int] = None,
    targetName: Input.Optional[String] = None,
    targets: Input.Optional[List[Input[String]]] = None,
    ttl: Input[Int],
    txt: Input.Optional[String] = None,
    typeBitmaps: Input.Optional[String] = None,
    typeCovered: Input.Optional[String] = None,
    typeMnemonic: Input.Optional[String] = None,
    typeValue: Input.Optional[Int] = None,
    usage: Input.Optional[Int] = None,
    weight: Input.Optional[Int] = None,
    zone: Input[String]
  )(using Context): DnsRecordArgs =
    new DnsRecordArgs(
      active = active.asOptionOutput(isSecret = false),
      algorithm = algorithm.asOptionOutput(isSecret = false),
      certificate = certificate.asOptionOutput(isSecret = false),
      digest = digest.asOptionOutput(isSecret = false),
      digestType = digestType.asOptionOutput(isSecret = false),
      emailAddress = emailAddress.asOptionOutput(isSecret = false),
      expiration = expiration.asOptionOutput(isSecret = false),
      expiry = expiry.asOptionOutput(isSecret = false),
      fingerprint = fingerprint.asOptionOutput(isSecret = false),
      fingerprintType = fingerprintType.asOptionOutput(isSecret = false),
      flags = flags.asOptionOutput(isSecret = false),
      flagsnaptr = flagsnaptr.asOptionOutput(isSecret = false),
      hardware = hardware.asOptionOutput(isSecret = false),
      inception = inception.asOptionOutput(isSecret = false),
      iterations = iterations.asOptionOutput(isSecret = false),
      key = key.asOptionOutput(isSecret = false),
      keytag = keytag.asOptionOutput(isSecret = false),
      labels = labels.asOptionOutput(isSecret = false),
      mailbox = mailbox.asOptionOutput(isSecret = false),
      matchType = matchType.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      nameServer = nameServer.asOptionOutput(isSecret = false),
      nextHashedOwnerName = nextHashedOwnerName.asOptionOutput(isSecret = false),
      nxdomainTtl = nxdomainTtl.asOptionOutput(isSecret = false),
      order = order.asOptionOutput(isSecret = false),
      originalTtl = originalTtl.asOptionOutput(isSecret = false),
      port = port.asOptionOutput(isSecret = false),
      preference = preference.asOptionOutput(isSecret = false),
      priority = priority.asOptionOutput(isSecret = false),
      priorityIncrement = priorityIncrement.asOptionOutput(isSecret = false),
      protocol = protocol.asOptionOutput(isSecret = false),
      recordtype = recordtype.asOutput(isSecret = false),
      refresh = refresh.asOptionOutput(isSecret = false),
      regexp = regexp.asOptionOutput(isSecret = false),
      replacement = replacement.asOptionOutput(isSecret = false),
      retry = retry.asOptionOutput(isSecret = false),
      salt = salt.asOptionOutput(isSecret = false),
      selector = selector.asOptionOutput(isSecret = false),
      service = service.asOptionOutput(isSecret = false),
      signature = signature.asOptionOutput(isSecret = false),
      signer = signer.asOptionOutput(isSecret = false),
      software = software.asOptionOutput(isSecret = false),
      subtype = subtype.asOptionOutput(isSecret = false),
      svcParams = svcParams.asOptionOutput(isSecret = false),
      svcPriority = svcPriority.asOptionOutput(isSecret = false),
      targetName = targetName.asOptionOutput(isSecret = false),
      targets = targets.asOptionOutput(isSecret = false),
      ttl = ttl.asOutput(isSecret = false),
      txt = txt.asOptionOutput(isSecret = false),
      typeBitmaps = typeBitmaps.asOptionOutput(isSecret = false),
      typeCovered = typeCovered.asOptionOutput(isSecret = false),
      typeMnemonic = typeMnemonic.asOptionOutput(isSecret = false),
      typeValue = typeValue.asOptionOutput(isSecret = false),
      usage = usage.asOptionOutput(isSecret = false),
      weight = weight.asOptionOutput(isSecret = false),
      zone = zone.asOutput(isSecret = false)
    )
