package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class DnsZone private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  activationState: Output[String],
  aliasCount: Output[Int],
  comment: Output[Option[String]],
  contract: Output[String],
  endCustomerId: Output[Option[String]],
  group: Output[Option[String]],
  masters: Output[Option[scala.collection.immutable.List[String]]],
  signAndServe: Output[Option[Boolean]],
  signAndServeAlgorithm: Output[Option[String]],
  target: Output[Option[String]],
  tsigKey: Output[Option[besom.api.akamai.outputs.DnsZoneTsigKey]],
  `type`: Output[String],
  versionId: Output[String],
  zone: Output[String]
) extends CustomResource derives ResourceDecoder

object DnsZone:
  given outputOps: {} with
    extension(output: Output[DnsZone])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def activationState: Output[String] = output.flatMap(_.activationState)
      def aliasCount: Output[Int] = output.flatMap(_.aliasCount)
      def comment: Output[Option[String]] = output.flatMap(_.comment)
      def contract: Output[String] = output.flatMap(_.contract)
      def endCustomerId: Output[Option[String]] = output.flatMap(_.endCustomerId)
      def group: Output[Option[String]] = output.flatMap(_.group)
      def masters: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.masters)
      def signAndServe: Output[Option[Boolean]] = output.flatMap(_.signAndServe)
      def signAndServeAlgorithm: Output[Option[String]] = output.flatMap(_.signAndServeAlgorithm)
      def target: Output[Option[String]] = output.flatMap(_.target)
      def tsigKey: Output[Option[besom.api.akamai.outputs.DnsZoneTsigKey]] = output.flatMap(_.tsigKey)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def versionId: Output[String] = output.flatMap(_.versionId)
      def zone: Output[String] = output.flatMap(_.zone)

def dnsZone(using ctx: Context)(
  name: NonEmptyString,
  args: DnsZoneArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[DnsZone] = 
  ctx.registerResource[DnsZone, DnsZoneArgs]("akamai:index/dnsZone:DnsZone", name, args, opts)

