package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class DnsZoneArgs private(
  comment: Output[Option[String]],
  contract: Output[String],
  endCustomerId: Output[Option[String]],
  group: Output[Option[String]],
  masters: Output[Option[scala.collection.immutable.List[String]]],
  signAndServe: Output[Option[Boolean]],
  signAndServeAlgorithm: Output[Option[String]],
  target: Output[Option[String]],
  tsigKey: Output[Option[besom.api.akamai.inputs.DnsZoneTsigKeyArgs]],
  `type`: Output[String],
  zone: Output[String]
) derives ArgsEncoder

object DnsZoneArgs:
  def apply(
    comment: Input.Optional[String] = None,
    contract: Input[String],
    endCustomerId: Input.Optional[String] = None,
    group: Input.Optional[String] = None,
    masters: Input.Optional[List[Input[String]]] = None,
    signAndServe: Input.Optional[Boolean] = None,
    signAndServeAlgorithm: Input.Optional[String] = None,
    target: Input.Optional[String] = None,
    tsigKey: Input.Optional[besom.api.akamai.inputs.DnsZoneTsigKeyArgs] = None,
    `type`: Input[String],
    zone: Input[String]
  )(using Context): DnsZoneArgs =
    new DnsZoneArgs(
      comment = comment.asOptionOutput(isSecret = false),
      contract = contract.asOutput(isSecret = false),
      endCustomerId = endCustomerId.asOptionOutput(isSecret = false),
      group = group.asOptionOutput(isSecret = false),
      masters = masters.asOptionOutput(isSecret = false),
      signAndServe = signAndServe.asOptionOutput(isSecret = false),
      signAndServeAlgorithm = signAndServeAlgorithm.asOptionOutput(isSecret = false),
      target = target.asOptionOutput(isSecret = false),
      tsigKey = tsigKey.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      zone = zone.asOutput(isSecret = false)
    )
