package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class EdgeHostName private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  certificate: Output[Option[Int]],
  contractId: Output[String],
  edgeHostname: Output[String],
  groupId: Output[String],
  ipBehavior: Output[String],
  productId: Output[String],
  statusUpdateEmails: Output[Option[scala.collection.immutable.List[String]]],
  useCases: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object EdgeHostName:
  given outputOps: {} with
    extension(output: Output[EdgeHostName])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def certificate: Output[Option[Int]] = output.flatMap(_.certificate)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def edgeHostname: Output[String] = output.flatMap(_.edgeHostname)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def ipBehavior: Output[String] = output.flatMap(_.ipBehavior)
      def productId: Output[String] = output.flatMap(_.productId)
      def statusUpdateEmails: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.statusUpdateEmails)
      def useCases: Output[Option[String]] = output.flatMap(_.useCases)

def edgeHostName(using ctx: Context)(
  name: NonEmptyString,
  args: EdgeHostNameArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[EdgeHostName] = 
  ctx.registerResource[EdgeHostName, EdgeHostNameArgs]("akamai:index/edgeHostName:EdgeHostName", name, args, opts)

