package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class EdgeHostNameArgs private(
  certificate: Output[Option[Int]],
  contractId: Output[String],
  edgeHostname: Output[String],
  groupId: Output[String],
  ipBehavior: Output[String],
  productId: Output[Option[String]],
  statusUpdateEmails: Output[Option[scala.collection.immutable.List[String]]],
  useCases: Output[Option[String]]
) derives ArgsEncoder

object EdgeHostNameArgs:
  def apply(
    certificate: Input.Optional[Int] = None,
    contractId: Input[String],
    edgeHostname: Input[String],
    groupId: Input[String],
    ipBehavior: Input[String],
    productId: Input.Optional[String] = None,
    statusUpdateEmails: Input.Optional[List[Input[String]]] = None,
    useCases: Input.Optional[String] = None
  )(using Context): EdgeHostNameArgs =
    new EdgeHostNameArgs(
      certificate = certificate.asOptionOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      edgeHostname = edgeHostname.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      ipBehavior = ipBehavior.asOutput(isSecret = false),
      productId = productId.asOptionOutput(isSecret = false),
      statusUpdateEmails = statusUpdateEmails.asOptionOutput(isSecret = false),
      useCases = useCases.asOptionOutput(isSecret = false)
    )
