package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class EdgeKv private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  geoLocation: Output[Option[String]],
  groupId: Output[Int],
  initialDatas: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.EdgeKvInitialData]]],
  namespaceName: Output[String],
  network: Output[String],
  retentionInSeconds: Output[Int]
) extends CustomResource derives ResourceDecoder

object EdgeKv:
  given outputOps: {} with
    extension(output: Output[EdgeKv])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def geoLocation: Output[Option[String]] = output.flatMap(_.geoLocation)
      def groupId: Output[Int] = output.flatMap(_.groupId)
      def initialDatas: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.EdgeKvInitialData]]] = output.flatMap(_.initialDatas)
      def namespaceName: Output[String] = output.flatMap(_.namespaceName)
      def network: Output[String] = output.flatMap(_.network)
      def retentionInSeconds: Output[Int] = output.flatMap(_.retentionInSeconds)

def edgeKv(using ctx: Context)(
  name: NonEmptyString,
  args: EdgeKvArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[EdgeKv] = 
  ctx.registerResource[EdgeKv, EdgeKvArgs]("akamai:index/edgeKv:EdgeKv", name, args, opts)

