package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class EdgeKvArgs private(
  geoLocation: Output[Option[String]],
  groupId: Output[Int],
  initialDatas: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.EdgeKvInitialDataArgs]]],
  namespaceName: Output[String],
  network: Output[String],
  retentionInSeconds: Output[Int]
) derives ArgsEncoder

object EdgeKvArgs:
  def apply(
    geoLocation: Input.Optional[String] = None,
    groupId: Input[Int],
    initialDatas: Input.Optional[List[Input[besom.api.akamai.inputs.EdgeKvInitialDataArgs]]] = None,
    namespaceName: Input[String],
    network: Input[String],
    retentionInSeconds: Input[Int]
  )(using Context): EdgeKvArgs =
    new EdgeKvArgs(
      geoLocation = geoLocation.asOptionOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      initialDatas = initialDatas.asOptionOutput(isSecret = false),
      namespaceName = namespaceName.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      retentionInSeconds = retentionInSeconds.asOutput(isSecret = false)
    )
