package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class EdgeWorker private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  edgeworkerId: Output[Int],
  groupId: Output[Int],
  localBundle: Output[Option[String]],
  localBundleHash: Output[String],
  name: Output[String],
  resourceTierId: Output[Int],
  version: Output[String],
  warnings: Output[scala.collection.immutable.List[String]]
) extends CustomResource derives ResourceDecoder

object EdgeWorker:
  given outputOps: {} with
    extension(output: Output[EdgeWorker])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def edgeworkerId: Output[Int] = output.flatMap(_.edgeworkerId)
      def groupId: Output[Int] = output.flatMap(_.groupId)
      def localBundle: Output[Option[String]] = output.flatMap(_.localBundle)
      def localBundleHash: Output[String] = output.flatMap(_.localBundleHash)
      def name: Output[String] = output.flatMap(_.name)
      def resourceTierId: Output[Int] = output.flatMap(_.resourceTierId)
      def version: Output[String] = output.flatMap(_.version)
      def warnings: Output[scala.collection.immutable.List[String]] = output.flatMap(_.warnings)

def edgeWorker(using ctx: Context)(
  name: NonEmptyString,
  args: EdgeWorkerArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[EdgeWorker] = 
  ctx.registerResource[EdgeWorker, EdgeWorkerArgs]("akamai:index/edgeWorker:EdgeWorker", name, args, opts)

