package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class EdgeWorkerArgs private(
  groupId: Output[Int],
  localBundle: Output[Option[String]],
  name: Output[Option[String]],
  resourceTierId: Output[Int]
) derives ArgsEncoder

object EdgeWorkerArgs:
  def apply(
    groupId: Input[Int],
    localBundle: Input.Optional[String] = None,
    name: Input.Optional[String] = None,
    resourceTierId: Input[Int]
  )(using Context): EdgeWorkerArgs =
    new EdgeWorkerArgs(
      groupId = groupId.asOutput(isSecret = false),
      localBundle = localBundle.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      resourceTierId = resourceTierId.asOutput(isSecret = false)
    )
