package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class EdgeWorkersActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  activationId: Output[Int],
  edgeworkerId: Output[Int],
  network: Output[String],
  version: Output[String]
) extends CustomResource derives ResourceDecoder

object EdgeWorkersActivation:
  given outputOps: {} with
    extension(output: Output[EdgeWorkersActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def activationId: Output[Int] = output.flatMap(_.activationId)
      def edgeworkerId: Output[Int] = output.flatMap(_.edgeworkerId)
      def network: Output[String] = output.flatMap(_.network)
      def version: Output[String] = output.flatMap(_.version)

def edgeWorkersActivation(using ctx: Context)(
  name: NonEmptyString,
  args: EdgeWorkersActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[EdgeWorkersActivation] = 
  ctx.registerResource[EdgeWorkersActivation, EdgeWorkersActivationArgs]("akamai:index/edgeWorkersActivation:EdgeWorkersActivation", name, args, opts)

