package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class EdgeWorkersActivationArgs private(
  edgeworkerId: Output[Int],
  network: Output[String],
  version: Output[String]
) derives ArgsEncoder

object EdgeWorkersActivationArgs:
  def apply(
    edgeworkerId: Input[Int],
    network: Input[String],
    version: Input[String]
  )(using Context): EdgeWorkersActivationArgs =
    new EdgeWorkersActivationArgs(
      edgeworkerId = edgeworkerId.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
