package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class EdgekvGroupItems private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  groupName: Output[String],
  items: Output[scala.Predef.Map[String, String]],
  namespaceName: Output[String],
  network: Output[String]
) extends CustomResource derives ResourceDecoder

object EdgekvGroupItems:
  given outputOps: {} with
    extension(output: Output[EdgekvGroupItems])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def groupName: Output[String] = output.flatMap(_.groupName)
      def items: Output[scala.Predef.Map[String, String]] = output.flatMap(_.items)
      def namespaceName: Output[String] = output.flatMap(_.namespaceName)
      def network: Output[String] = output.flatMap(_.network)

def edgekvGroupItems(using ctx: Context)(
  name: NonEmptyString,
  args: EdgekvGroupItemsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[EdgekvGroupItems] = 
  ctx.registerResource[EdgekvGroupItems, EdgekvGroupItemsArgs]("akamai:index/edgekvGroupItems:EdgekvGroupItems", name, args, opts)

