package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class EdgekvGroupItemsArgs private(
  groupName: Output[String],
  items: Output[scala.Predef.Map[String, String]],
  namespaceName: Output[String],
  network: Output[String]
) derives ArgsEncoder

object EdgekvGroupItemsArgs:
  def apply(
    groupName: Input[String],
    items: Input[scala.Predef.Map[String, Input[String]]],
    namespaceName: Input[String],
    network: Input[String]
  )(using Context): EdgekvGroupItemsArgs =
    new EdgekvGroupItemsArgs(
      groupName = groupName.asOutput(isSecret = false),
      items = items.asOutput(isSecret = false),
      namespaceName = namespaceName.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false)
    )
