package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmAsmap private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmAsmapAssignment]]],
  defaultDatacenter: Output[besom.api.akamai.outputs.GtmAsmapDefaultDatacenter],
  domain: Output[String],
  name: Output[String],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmAsmap:
  given outputOps: {} with
    extension(output: Output[GtmAsmap])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmAsmapAssignment]]] = output.flatMap(_.assignments)
      def defaultDatacenter: Output[besom.api.akamai.outputs.GtmAsmapDefaultDatacenter] = output.flatMap(_.defaultDatacenter)
      def domain: Output[String] = output.flatMap(_.domain)
      def name: Output[String] = output.flatMap(_.name)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmAsmap(using ctx: Context)(
  name: NonEmptyString,
  args: GtmAsmapArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmAsmap] = 
  ctx.registerResource[GtmAsmap, GtmAsmapArgs]("akamai:index/gtmAsmap:GtmAsmap", name, args, opts)

