package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmAsmapArgs private(
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmAsmapAssignmentArgs]]],
  defaultDatacenter: Output[besom.api.akamai.inputs.GtmAsmapDefaultDatacenterArgs],
  domain: Output[String],
  name: Output[Option[String]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmAsmapArgs:
  def apply(
    assignments: Input.Optional[List[Input[besom.api.akamai.inputs.GtmAsmapAssignmentArgs]]] = None,
    defaultDatacenter: Input[besom.api.akamai.inputs.GtmAsmapDefaultDatacenterArgs],
    domain: Input[String],
    name: Input.Optional[String] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmAsmapArgs =
    new GtmAsmapArgs(
      assignments = assignments.asOptionOutput(isSecret = false),
      defaultDatacenter = defaultDatacenter.asOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
