package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmCidrmap private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmCidrmapAssignment]]],
  defaultDatacenter: Output[besom.api.akamai.outputs.GtmCidrmapDefaultDatacenter],
  domain: Output[String],
  name: Output[String],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmCidrmap:
  given outputOps: {} with
    extension(output: Output[GtmCidrmap])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmCidrmapAssignment]]] = output.flatMap(_.assignments)
      def defaultDatacenter: Output[besom.api.akamai.outputs.GtmCidrmapDefaultDatacenter] = output.flatMap(_.defaultDatacenter)
      def domain: Output[String] = output.flatMap(_.domain)
      def name: Output[String] = output.flatMap(_.name)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmCidrmap(using ctx: Context)(
  name: NonEmptyString,
  args: GtmCidrmapArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmCidrmap] = 
  ctx.registerResource[GtmCidrmap, GtmCidrmapArgs]("akamai:index/gtmCidrmap:GtmCidrmap", name, args, opts)

