package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmCidrmapArgs private(
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmCidrmapAssignmentArgs]]],
  defaultDatacenter: Output[besom.api.akamai.inputs.GtmCidrmapDefaultDatacenterArgs],
  domain: Output[String],
  name: Output[Option[String]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmCidrmapArgs:
  def apply(
    assignments: Input.Optional[List[Input[besom.api.akamai.inputs.GtmCidrmapAssignmentArgs]]] = None,
    defaultDatacenter: Input[besom.api.akamai.inputs.GtmCidrmapDefaultDatacenterArgs],
    domain: Input[String],
    name: Input.Optional[String] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmCidrmapArgs =
    new GtmCidrmapArgs(
      assignments = assignments.asOptionOutput(isSecret = false),
      defaultDatacenter = defaultDatacenter.asOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
