package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmDatacenter private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  city: Output[Option[String]],
  cloneOf: Output[Option[Int]],
  cloudServerHostHeaderOverride: Output[Option[Boolean]],
  cloudServerTargeting: Output[Option[Boolean]],
  continent: Output[Option[String]],
  country: Output[Option[String]],
  datacenterId: Output[Int],
  defaultLoadObject: Output[Option[besom.api.akamai.outputs.GtmDatacenterDefaultLoadObject]],
  domain: Output[String],
  latitude: Output[Option[Double]],
  longitude: Output[Option[Double]],
  nickname: Output[Option[String]],
  pingInterval: Output[Int],
  pingPacketSize: Output[Int],
  scorePenalty: Output[Int],
  servermonitorLivenessCount: Output[Int],
  servermonitorLoadCount: Output[Int],
  servermonitorPool: Output[String],
  stateOrProvince: Output[Option[String]],
  virtual: Output[Boolean],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmDatacenter:
  given outputOps: {} with
    extension(output: Output[GtmDatacenter])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def city: Output[Option[String]] = output.flatMap(_.city)
      def cloneOf: Output[Option[Int]] = output.flatMap(_.cloneOf)
      def cloudServerHostHeaderOverride: Output[Option[Boolean]] = output.flatMap(_.cloudServerHostHeaderOverride)
      def cloudServerTargeting: Output[Option[Boolean]] = output.flatMap(_.cloudServerTargeting)
      def continent: Output[Option[String]] = output.flatMap(_.continent)
      def country: Output[Option[String]] = output.flatMap(_.country)
      def datacenterId: Output[Int] = output.flatMap(_.datacenterId)
      def defaultLoadObject: Output[Option[besom.api.akamai.outputs.GtmDatacenterDefaultLoadObject]] = output.flatMap(_.defaultLoadObject)
      def domain: Output[String] = output.flatMap(_.domain)
      def latitude: Output[Option[Double]] = output.flatMap(_.latitude)
      def longitude: Output[Option[Double]] = output.flatMap(_.longitude)
      def nickname: Output[Option[String]] = output.flatMap(_.nickname)
      def pingInterval: Output[Int] = output.flatMap(_.pingInterval)
      def pingPacketSize: Output[Int] = output.flatMap(_.pingPacketSize)
      def scorePenalty: Output[Int] = output.flatMap(_.scorePenalty)
      def servermonitorLivenessCount: Output[Int] = output.flatMap(_.servermonitorLivenessCount)
      def servermonitorLoadCount: Output[Int] = output.flatMap(_.servermonitorLoadCount)
      def servermonitorPool: Output[String] = output.flatMap(_.servermonitorPool)
      def stateOrProvince: Output[Option[String]] = output.flatMap(_.stateOrProvince)
      def virtual: Output[Boolean] = output.flatMap(_.virtual)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmDatacenter(using ctx: Context)(
  name: NonEmptyString,
  args: GtmDatacenterArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmDatacenter] = 
  ctx.registerResource[GtmDatacenter, GtmDatacenterArgs]("akamai:index/gtmDatacenter:GtmDatacenter", name, args, opts)

