package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmDatacenterArgs private(
  city: Output[Option[String]],
  cloneOf: Output[Option[Int]],
  cloudServerHostHeaderOverride: Output[Option[Boolean]],
  cloudServerTargeting: Output[Option[Boolean]],
  continent: Output[Option[String]],
  country: Output[Option[String]],
  defaultLoadObject: Output[Option[besom.api.akamai.inputs.GtmDatacenterDefaultLoadObjectArgs]],
  domain: Output[String],
  latitude: Output[Option[Double]],
  longitude: Output[Option[Double]],
  nickname: Output[Option[String]],
  stateOrProvince: Output[Option[String]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmDatacenterArgs:
  def apply(
    city: Input.Optional[String] = None,
    cloneOf: Input.Optional[Int] = None,
    cloudServerHostHeaderOverride: Input.Optional[Boolean] = None,
    cloudServerTargeting: Input.Optional[Boolean] = None,
    continent: Input.Optional[String] = None,
    country: Input.Optional[String] = None,
    defaultLoadObject: Input.Optional[besom.api.akamai.inputs.GtmDatacenterDefaultLoadObjectArgs] = None,
    domain: Input[String],
    latitude: Input.Optional[Double] = None,
    longitude: Input.Optional[Double] = None,
    nickname: Input.Optional[String] = None,
    stateOrProvince: Input.Optional[String] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmDatacenterArgs =
    new GtmDatacenterArgs(
      city = city.asOptionOutput(isSecret = false),
      cloneOf = cloneOf.asOptionOutput(isSecret = false),
      cloudServerHostHeaderOverride = cloudServerHostHeaderOverride.asOptionOutput(isSecret = false),
      cloudServerTargeting = cloudServerTargeting.asOptionOutput(isSecret = false),
      continent = continent.asOptionOutput(isSecret = false),
      country = country.asOptionOutput(isSecret = false),
      defaultLoadObject = defaultLoadObject.asOptionOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      latitude = latitude.asOptionOutput(isSecret = false),
      longitude = longitude.asOptionOutput(isSecret = false),
      nickname = nickname.asOptionOutput(isSecret = false),
      stateOrProvince = stateOrProvince.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
