package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmDomain private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  cnameCoalescingEnabled: Output[Option[Boolean]],
  comment: Output[Option[String]],
  contract: Output[Option[String]],
  defaultErrorPenalty: Output[Option[Int]],
  defaultHealthMax: Output[Double],
  defaultHealthMultiplier: Output[Double],
  defaultHealthThreshold: Output[Double],
  defaultMaxUnreachablePenalty: Output[Int],
  defaultSslClientCertificate: Output[Option[String]],
  defaultSslClientPrivateKey: Output[Option[String]],
  defaultTimeoutPenalty: Output[Option[Int]],
  defaultUnreachableThreshold: Output[Double],
  emailNotificationLists: Output[Option[scala.collection.immutable.List[String]]],
  endUserMappingEnabled: Output[Option[Boolean]],
  group: Output[Option[String]],
  loadFeedback: Output[Option[Boolean]],
  loadImbalancePercentage: Output[Option[Double]],
  mapUpdateInterval: Output[Int],
  maxProperties: Output[Int],
  maxResources: Output[Int],
  maxTestTimeout: Output[Double],
  maxTtl: Output[Int],
  minPingableRegionFraction: Output[Double],
  minTestInterval: Output[Int],
  minTtl: Output[Int],
  name: Output[String],
  pingInterval: Output[Int],
  pingPacketSize: Output[Int],
  roundRobinPrefix: Output[String],
  servermonitorLivenessCount: Output[Int],
  servermonitorLoadCount: Output[Int],
  servermonitorPool: Output[String],
  `type`: Output[String],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmDomain:
  given outputOps: {} with
    extension(output: Output[GtmDomain])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def cnameCoalescingEnabled: Output[Option[Boolean]] = output.flatMap(_.cnameCoalescingEnabled)
      def comment: Output[Option[String]] = output.flatMap(_.comment)
      def contract: Output[Option[String]] = output.flatMap(_.contract)
      def defaultErrorPenalty: Output[Option[Int]] = output.flatMap(_.defaultErrorPenalty)
      def defaultHealthMax: Output[Double] = output.flatMap(_.defaultHealthMax)
      def defaultHealthMultiplier: Output[Double] = output.flatMap(_.defaultHealthMultiplier)
      def defaultHealthThreshold: Output[Double] = output.flatMap(_.defaultHealthThreshold)
      def defaultMaxUnreachablePenalty: Output[Int] = output.flatMap(_.defaultMaxUnreachablePenalty)
      def defaultSslClientCertificate: Output[Option[String]] = output.flatMap(_.defaultSslClientCertificate)
      def defaultSslClientPrivateKey: Output[Option[String]] = output.flatMap(_.defaultSslClientPrivateKey)
      def defaultTimeoutPenalty: Output[Option[Int]] = output.flatMap(_.defaultTimeoutPenalty)
      def defaultUnreachableThreshold: Output[Double] = output.flatMap(_.defaultUnreachableThreshold)
      def emailNotificationLists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.emailNotificationLists)
      def endUserMappingEnabled: Output[Option[Boolean]] = output.flatMap(_.endUserMappingEnabled)
      def group: Output[Option[String]] = output.flatMap(_.group)
      def loadFeedback: Output[Option[Boolean]] = output.flatMap(_.loadFeedback)
      def loadImbalancePercentage: Output[Option[Double]] = output.flatMap(_.loadImbalancePercentage)
      def mapUpdateInterval: Output[Int] = output.flatMap(_.mapUpdateInterval)
      def maxProperties: Output[Int] = output.flatMap(_.maxProperties)
      def maxResources: Output[Int] = output.flatMap(_.maxResources)
      def maxTestTimeout: Output[Double] = output.flatMap(_.maxTestTimeout)
      def maxTtl: Output[Int] = output.flatMap(_.maxTtl)
      def minPingableRegionFraction: Output[Double] = output.flatMap(_.minPingableRegionFraction)
      def minTestInterval: Output[Int] = output.flatMap(_.minTestInterval)
      def minTtl: Output[Int] = output.flatMap(_.minTtl)
      def name: Output[String] = output.flatMap(_.name)
      def pingInterval: Output[Int] = output.flatMap(_.pingInterval)
      def pingPacketSize: Output[Int] = output.flatMap(_.pingPacketSize)
      def roundRobinPrefix: Output[String] = output.flatMap(_.roundRobinPrefix)
      def servermonitorLivenessCount: Output[Int] = output.flatMap(_.servermonitorLivenessCount)
      def servermonitorLoadCount: Output[Int] = output.flatMap(_.servermonitorLoadCount)
      def servermonitorPool: Output[String] = output.flatMap(_.servermonitorPool)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmDomain(using ctx: Context)(
  name: NonEmptyString,
  args: GtmDomainArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmDomain] = 
  ctx.registerResource[GtmDomain, GtmDomainArgs]("akamai:index/gtmDomain:GtmDomain", name, args, opts)

