package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmDomainArgs private(
  cnameCoalescingEnabled: Output[Option[Boolean]],
  comment: Output[Option[String]],
  contract: Output[Option[String]],
  defaultErrorPenalty: Output[Option[Int]],
  defaultSslClientCertificate: Output[Option[String]],
  defaultSslClientPrivateKey: Output[Option[String]],
  defaultTimeoutPenalty: Output[Option[Int]],
  emailNotificationLists: Output[Option[scala.collection.immutable.List[String]]],
  endUserMappingEnabled: Output[Option[Boolean]],
  group: Output[Option[String]],
  loadFeedback: Output[Option[Boolean]],
  loadImbalancePercentage: Output[Option[Double]],
  name: Output[Option[String]],
  `type`: Output[String],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmDomainArgs:
  def apply(
    cnameCoalescingEnabled: Input.Optional[Boolean] = None,
    comment: Input.Optional[String] = None,
    contract: Input.Optional[String] = None,
    defaultErrorPenalty: Input.Optional[Int] = None,
    defaultSslClientCertificate: Input.Optional[String] = None,
    defaultSslClientPrivateKey: Input.Optional[String] = None,
    defaultTimeoutPenalty: Input.Optional[Int] = None,
    emailNotificationLists: Input.Optional[List[Input[String]]] = None,
    endUserMappingEnabled: Input.Optional[Boolean] = None,
    group: Input.Optional[String] = None,
    loadFeedback: Input.Optional[Boolean] = None,
    loadImbalancePercentage: Input.Optional[Double] = None,
    name: Input.Optional[String] = None,
    `type`: Input[String],
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmDomainArgs =
    new GtmDomainArgs(
      cnameCoalescingEnabled = cnameCoalescingEnabled.asOptionOutput(isSecret = false),
      comment = comment.asOptionOutput(isSecret = false),
      contract = contract.asOptionOutput(isSecret = false),
      defaultErrorPenalty = defaultErrorPenalty.asOptionOutput(isSecret = false),
      defaultSslClientCertificate = defaultSslClientCertificate.asOptionOutput(isSecret = false),
      defaultSslClientPrivateKey = defaultSslClientPrivateKey.asOptionOutput(isSecret = false),
      defaultTimeoutPenalty = defaultTimeoutPenalty.asOptionOutput(isSecret = false),
      emailNotificationLists = emailNotificationLists.asOptionOutput(isSecret = false),
      endUserMappingEnabled = endUserMappingEnabled.asOptionOutput(isSecret = false),
      group = group.asOptionOutput(isSecret = false),
      loadFeedback = loadFeedback.asOptionOutput(isSecret = false),
      loadImbalancePercentage = loadImbalancePercentage.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
