package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmGeomap private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmGeomapAssignment]]],
  defaultDatacenter: Output[besom.api.akamai.outputs.GtmGeomapDefaultDatacenter],
  domain: Output[String],
  name: Output[String],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmGeomap:
  given outputOps: {} with
    extension(output: Output[GtmGeomap])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmGeomapAssignment]]] = output.flatMap(_.assignments)
      def defaultDatacenter: Output[besom.api.akamai.outputs.GtmGeomapDefaultDatacenter] = output.flatMap(_.defaultDatacenter)
      def domain: Output[String] = output.flatMap(_.domain)
      def name: Output[String] = output.flatMap(_.name)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmGeomap(using ctx: Context)(
  name: NonEmptyString,
  args: GtmGeomapArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmGeomap] = 
  ctx.registerResource[GtmGeomap, GtmGeomapArgs]("akamai:index/gtmGeomap:GtmGeomap", name, args, opts)

