package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmGeomapArgs private(
  assignments: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmGeomapAssignmentArgs]]],
  defaultDatacenter: Output[besom.api.akamai.inputs.GtmGeomapDefaultDatacenterArgs],
  domain: Output[String],
  name: Output[Option[String]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmGeomapArgs:
  def apply(
    assignments: Input.Optional[List[Input[besom.api.akamai.inputs.GtmGeomapAssignmentArgs]]] = None,
    defaultDatacenter: Input[besom.api.akamai.inputs.GtmGeomapDefaultDatacenterArgs],
    domain: Input[String],
    name: Input.Optional[String] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmGeomapArgs =
    new GtmGeomapArgs(
      assignments = assignments.asOptionOutput(isSecret = false),
      defaultDatacenter = defaultDatacenter.asOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
