package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmProperty private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  backupCname: Output[Option[String]],
  backupIp: Output[Option[String]],
  balanceByDownloadScore: Output[Option[Boolean]],
  cname: Output[Option[String]],
  comments: Output[Option[String]],
  domain: Output[String],
  dynamicTtl: Output[Option[Int]],
  failbackDelay: Output[Option[Int]],
  failoverDelay: Output[Option[Int]],
  ghostDemandReporting: Output[Option[Boolean]],
  handoutLimit: Output[Int],
  handoutMode: Output[String],
  healthMax: Output[Option[Double]],
  healthMultiplier: Output[Option[Double]],
  healthThreshold: Output[Option[Double]],
  ipv6: Output[Option[Boolean]],
  livenessTests: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyLivenessTest]]],
  loadImbalancePercentage: Output[Option[Double]],
  mapName: Output[Option[String]],
  maxUnreachablePenalty: Output[Option[Int]],
  minLiveFraction: Output[Option[Double]],
  name: Output[String],
  scoreAggregationType: Output[String],
  staticRrSets: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyStaticRrSet]]],
  staticTtl: Output[Option[Int]],
  stickinessBonusConstant: Output[Option[Int]],
  stickinessBonusPercentage: Output[Option[Int]],
  trafficTargets: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyTrafficTarget]]],
  `type`: Output[String],
  unreachableThreshold: Output[Option[Double]],
  useComputedTargets: Output[Option[Boolean]],
  waitOnComplete: Output[Option[Boolean]],
  weightedHashBitsForIpv4: Output[Int],
  weightedHashBitsForIpv6: Output[Int]
) extends CustomResource derives ResourceDecoder

object GtmProperty:
  given outputOps: {} with
    extension(output: Output[GtmProperty])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def backupCname: Output[Option[String]] = output.flatMap(_.backupCname)
      def backupIp: Output[Option[String]] = output.flatMap(_.backupIp)
      def balanceByDownloadScore: Output[Option[Boolean]] = output.flatMap(_.balanceByDownloadScore)
      def cname: Output[Option[String]] = output.flatMap(_.cname)
      def comments: Output[Option[String]] = output.flatMap(_.comments)
      def domain: Output[String] = output.flatMap(_.domain)
      def dynamicTtl: Output[Option[Int]] = output.flatMap(_.dynamicTtl)
      def failbackDelay: Output[Option[Int]] = output.flatMap(_.failbackDelay)
      def failoverDelay: Output[Option[Int]] = output.flatMap(_.failoverDelay)
      def ghostDemandReporting: Output[Option[Boolean]] = output.flatMap(_.ghostDemandReporting)
      def handoutLimit: Output[Int] = output.flatMap(_.handoutLimit)
      def handoutMode: Output[String] = output.flatMap(_.handoutMode)
      def healthMax: Output[Option[Double]] = output.flatMap(_.healthMax)
      def healthMultiplier: Output[Option[Double]] = output.flatMap(_.healthMultiplier)
      def healthThreshold: Output[Option[Double]] = output.flatMap(_.healthThreshold)
      def ipv6: Output[Option[Boolean]] = output.flatMap(_.ipv6)
      def livenessTests: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyLivenessTest]]] = output.flatMap(_.livenessTests)
      def loadImbalancePercentage: Output[Option[Double]] = output.flatMap(_.loadImbalancePercentage)
      def mapName: Output[Option[String]] = output.flatMap(_.mapName)
      def maxUnreachablePenalty: Output[Option[Int]] = output.flatMap(_.maxUnreachablePenalty)
      def minLiveFraction: Output[Option[Double]] = output.flatMap(_.minLiveFraction)
      def name: Output[String] = output.flatMap(_.name)
      def scoreAggregationType: Output[String] = output.flatMap(_.scoreAggregationType)
      def staticRrSets: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyStaticRrSet]]] = output.flatMap(_.staticRrSets)
      def staticTtl: Output[Option[Int]] = output.flatMap(_.staticTtl)
      def stickinessBonusConstant: Output[Option[Int]] = output.flatMap(_.stickinessBonusConstant)
      def stickinessBonusPercentage: Output[Option[Int]] = output.flatMap(_.stickinessBonusPercentage)
      def trafficTargets: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyTrafficTarget]]] = output.flatMap(_.trafficTargets)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def unreachableThreshold: Output[Option[Double]] = output.flatMap(_.unreachableThreshold)
      def useComputedTargets: Output[Option[Boolean]] = output.flatMap(_.useComputedTargets)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)
      def weightedHashBitsForIpv4: Output[Int] = output.flatMap(_.weightedHashBitsForIpv4)
      def weightedHashBitsForIpv6: Output[Int] = output.flatMap(_.weightedHashBitsForIpv6)

def gtmProperty(using ctx: Context)(
  name: NonEmptyString,
  args: GtmPropertyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmProperty] = 
  ctx.registerResource[GtmProperty, GtmPropertyArgs]("akamai:index/gtmProperty:GtmProperty", name, args, opts)

