package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmPropertyArgs private(
  backupCname: Output[Option[String]],
  backupIp: Output[Option[String]],
  balanceByDownloadScore: Output[Option[Boolean]],
  cname: Output[Option[String]],
  comments: Output[Option[String]],
  domain: Output[String],
  dynamicTtl: Output[Option[Int]],
  failbackDelay: Output[Option[Int]],
  failoverDelay: Output[Option[Int]],
  ghostDemandReporting: Output[Option[Boolean]],
  handoutLimit: Output[Int],
  handoutMode: Output[String],
  healthMax: Output[Option[Double]],
  healthMultiplier: Output[Option[Double]],
  healthThreshold: Output[Option[Double]],
  ipv6: Output[Option[Boolean]],
  livenessTests: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmPropertyLivenessTestArgs]]],
  loadImbalancePercentage: Output[Option[Double]],
  mapName: Output[Option[String]],
  maxUnreachablePenalty: Output[Option[Int]],
  minLiveFraction: Output[Option[Double]],
  name: Output[Option[String]],
  scoreAggregationType: Output[String],
  staticRrSets: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmPropertyStaticRrSetArgs]]],
  staticTtl: Output[Option[Int]],
  stickinessBonusConstant: Output[Option[Int]],
  stickinessBonusPercentage: Output[Option[Int]],
  trafficTargets: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmPropertyTrafficTargetArgs]]],
  `type`: Output[String],
  unreachableThreshold: Output[Option[Double]],
  useComputedTargets: Output[Option[Boolean]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmPropertyArgs:
  def apply(
    backupCname: Input.Optional[String] = None,
    backupIp: Input.Optional[String] = None,
    balanceByDownloadScore: Input.Optional[Boolean] = None,
    cname: Input.Optional[String] = None,
    comments: Input.Optional[String] = None,
    domain: Input[String],
    dynamicTtl: Input.Optional[Int] = None,
    failbackDelay: Input.Optional[Int] = None,
    failoverDelay: Input.Optional[Int] = None,
    ghostDemandReporting: Input.Optional[Boolean] = None,
    handoutLimit: Input[Int],
    handoutMode: Input[String],
    healthMax: Input.Optional[Double] = None,
    healthMultiplier: Input.Optional[Double] = None,
    healthThreshold: Input.Optional[Double] = None,
    ipv6: Input.Optional[Boolean] = None,
    livenessTests: Input.Optional[List[Input[besom.api.akamai.inputs.GtmPropertyLivenessTestArgs]]] = None,
    loadImbalancePercentage: Input.Optional[Double] = None,
    mapName: Input.Optional[String] = None,
    maxUnreachablePenalty: Input.Optional[Int] = None,
    minLiveFraction: Input.Optional[Double] = None,
    name: Input.Optional[String] = None,
    scoreAggregationType: Input[String],
    staticRrSets: Input.Optional[List[Input[besom.api.akamai.inputs.GtmPropertyStaticRrSetArgs]]] = None,
    staticTtl: Input.Optional[Int] = None,
    stickinessBonusConstant: Input.Optional[Int] = None,
    stickinessBonusPercentage: Input.Optional[Int] = None,
    trafficTargets: Input.Optional[List[Input[besom.api.akamai.inputs.GtmPropertyTrafficTargetArgs]]] = None,
    `type`: Input[String],
    unreachableThreshold: Input.Optional[Double] = None,
    useComputedTargets: Input.Optional[Boolean] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmPropertyArgs =
    new GtmPropertyArgs(
      backupCname = backupCname.asOptionOutput(isSecret = false),
      backupIp = backupIp.asOptionOutput(isSecret = false),
      balanceByDownloadScore = balanceByDownloadScore.asOptionOutput(isSecret = false),
      cname = cname.asOptionOutput(isSecret = false),
      comments = comments.asOptionOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      dynamicTtl = dynamicTtl.asOptionOutput(isSecret = false),
      failbackDelay = failbackDelay.asOptionOutput(isSecret = false),
      failoverDelay = failoverDelay.asOptionOutput(isSecret = false),
      ghostDemandReporting = ghostDemandReporting.asOptionOutput(isSecret = false),
      handoutLimit = handoutLimit.asOutput(isSecret = false),
      handoutMode = handoutMode.asOutput(isSecret = false),
      healthMax = healthMax.asOptionOutput(isSecret = false),
      healthMultiplier = healthMultiplier.asOptionOutput(isSecret = false),
      healthThreshold = healthThreshold.asOptionOutput(isSecret = false),
      ipv6 = ipv6.asOptionOutput(isSecret = false),
      livenessTests = livenessTests.asOptionOutput(isSecret = false),
      loadImbalancePercentage = loadImbalancePercentage.asOptionOutput(isSecret = false),
      mapName = mapName.asOptionOutput(isSecret = false),
      maxUnreachablePenalty = maxUnreachablePenalty.asOptionOutput(isSecret = false),
      minLiveFraction = minLiveFraction.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      scoreAggregationType = scoreAggregationType.asOutput(isSecret = false),
      staticRrSets = staticRrSets.asOptionOutput(isSecret = false),
      staticTtl = staticTtl.asOptionOutput(isSecret = false),
      stickinessBonusConstant = stickinessBonusConstant.asOptionOutput(isSecret = false),
      stickinessBonusPercentage = stickinessBonusPercentage.asOptionOutput(isSecret = false),
      trafficTargets = trafficTargets.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      unreachableThreshold = unreachableThreshold.asOptionOutput(isSecret = false),
      useComputedTargets = useComputedTargets.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
