package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GtmResource private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  aggregationType: Output[String],
  constrainedProperty: Output[Option[String]],
  decayRate: Output[Option[Double]],
  description: Output[Option[String]],
  domain: Output[String],
  hostHeader: Output[Option[String]],
  leaderString: Output[Option[String]],
  leastSquaresDecay: Output[Option[Double]],
  loadImbalancePercentage: Output[Option[Double]],
  maxUMultiplicativeIncrement: Output[Option[Double]],
  name: Output[String],
  resourceInstances: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmResourceResourceInstance]]],
  `type`: Output[String],
  upperBound: Output[Option[Int]],
  waitOnComplete: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object GtmResource:
  given outputOps: {} with
    extension(output: Output[GtmResource])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def aggregationType: Output[String] = output.flatMap(_.aggregationType)
      def constrainedProperty: Output[Option[String]] = output.flatMap(_.constrainedProperty)
      def decayRate: Output[Option[Double]] = output.flatMap(_.decayRate)
      def description: Output[Option[String]] = output.flatMap(_.description)
      def domain: Output[String] = output.flatMap(_.domain)
      def hostHeader: Output[Option[String]] = output.flatMap(_.hostHeader)
      def leaderString: Output[Option[String]] = output.flatMap(_.leaderString)
      def leastSquaresDecay: Output[Option[Double]] = output.flatMap(_.leastSquaresDecay)
      def loadImbalancePercentage: Output[Option[Double]] = output.flatMap(_.loadImbalancePercentage)
      def maxUMultiplicativeIncrement: Output[Option[Double]] = output.flatMap(_.maxUMultiplicativeIncrement)
      def name: Output[String] = output.flatMap(_.name)
      def resourceInstances: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmResourceResourceInstance]]] = output.flatMap(_.resourceInstances)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def upperBound: Output[Option[Int]] = output.flatMap(_.upperBound)
      def waitOnComplete: Output[Option[Boolean]] = output.flatMap(_.waitOnComplete)

def gtmResource(using ctx: Context)(
  name: NonEmptyString,
  args: GtmResourceArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GtmResource] = 
  ctx.registerResource[GtmResource, GtmResourceArgs]("akamai:index/gtmResource:GtmResource", name, args, opts)

