package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GtmResourceArgs private(
  aggregationType: Output[String],
  constrainedProperty: Output[Option[String]],
  decayRate: Output[Option[Double]],
  description: Output[Option[String]],
  domain: Output[String],
  hostHeader: Output[Option[String]],
  leaderString: Output[Option[String]],
  leastSquaresDecay: Output[Option[Double]],
  loadImbalancePercentage: Output[Option[Double]],
  maxUMultiplicativeIncrement: Output[Option[Double]],
  name: Output[Option[String]],
  resourceInstances: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmResourceResourceInstanceArgs]]],
  `type`: Output[String],
  upperBound: Output[Option[Int]],
  waitOnComplete: Output[Option[Boolean]]
) derives ArgsEncoder

object GtmResourceArgs:
  def apply(
    aggregationType: Input[String],
    constrainedProperty: Input.Optional[String] = None,
    decayRate: Input.Optional[Double] = None,
    description: Input.Optional[String] = None,
    domain: Input[String],
    hostHeader: Input.Optional[String] = None,
    leaderString: Input.Optional[String] = None,
    leastSquaresDecay: Input.Optional[Double] = None,
    loadImbalancePercentage: Input.Optional[Double] = None,
    maxUMultiplicativeIncrement: Input.Optional[Double] = None,
    name: Input.Optional[String] = None,
    resourceInstances: Input.Optional[List[Input[besom.api.akamai.inputs.GtmResourceResourceInstanceArgs]]] = None,
    `type`: Input[String],
    upperBound: Input.Optional[Int] = None,
    waitOnComplete: Input.Optional[Boolean] = None
  )(using Context): GtmResourceArgs =
    new GtmResourceArgs(
      aggregationType = aggregationType.asOutput(isSecret = false),
      constrainedProperty = constrainedProperty.asOptionOutput(isSecret = false),
      decayRate = decayRate.asOptionOutput(isSecret = false),
      description = description.asOptionOutput(isSecret = false),
      domain = domain.asOutput(isSecret = false),
      hostHeader = hostHeader.asOptionOutput(isSecret = false),
      leaderString = leaderString.asOptionOutput(isSecret = false),
      leastSquaresDecay = leastSquaresDecay.asOptionOutput(isSecret = false),
      loadImbalancePercentage = loadImbalancePercentage.asOptionOutput(isSecret = false),
      maxUMultiplicativeIncrement = maxUMultiplicativeIncrement.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      resourceInstances = resourceInstances.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      upperBound = upperBound.asOptionOutput(isSecret = false),
      waitOnComplete = waitOnComplete.asOptionOutput(isSecret = false)
    )
