package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class IamBlockedUserProperties private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  blockedProperties: Output[scala.collection.immutable.List[Int]],
  groupId: Output[Int],
  identityId: Output[String]
) extends CustomResource derives ResourceDecoder

object IamBlockedUserProperties:
  given outputOps: {} with
    extension(output: Output[IamBlockedUserProperties])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def blockedProperties: Output[scala.collection.immutable.List[Int]] = output.flatMap(_.blockedProperties)
      def groupId: Output[Int] = output.flatMap(_.groupId)
      def identityId: Output[String] = output.flatMap(_.identityId)

def iamBlockedUserProperties(using ctx: Context)(
  name: NonEmptyString,
  args: IamBlockedUserPropertiesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[IamBlockedUserProperties] = 
  ctx.registerResource[IamBlockedUserProperties, IamBlockedUserPropertiesArgs]("akamai:index/iamBlockedUserProperties:IamBlockedUserProperties", name, args, opts)

