package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class IamBlockedUserPropertiesArgs private(
  blockedProperties: Output[scala.collection.immutable.List[Int]],
  groupId: Output[Int],
  identityId: Output[String]
) derives ArgsEncoder

object IamBlockedUserPropertiesArgs:
  def apply(
    blockedProperties: Input[List[Input[Int]]],
    groupId: Input[Int],
    identityId: Input[String]
  )(using Context): IamBlockedUserPropertiesArgs =
    new IamBlockedUserPropertiesArgs(
      blockedProperties = blockedProperties.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      identityId = identityId.asOutput(isSecret = false)
    )
