package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class IamGroup private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  name: Output[String],
  parentGroupId: Output[Int],
  subGroups: Output[scala.collection.immutable.List[Int]]
) extends CustomResource derives ResourceDecoder

object IamGroup:
  given outputOps: {} with
    extension(output: Output[IamGroup])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def name: Output[String] = output.flatMap(_.name)
      def parentGroupId: Output[Int] = output.flatMap(_.parentGroupId)
      def subGroups: Output[scala.collection.immutable.List[Int]] = output.flatMap(_.subGroups)

def iamGroup(using ctx: Context)(
  name: NonEmptyString,
  args: IamGroupArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[IamGroup] = 
  ctx.registerResource[IamGroup, IamGroupArgs]("akamai:index/iamGroup:IamGroup", name, args, opts)

