package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class IamGroupArgs private(
  name: Output[Option[String]],
  parentGroupId: Output[Int]
) derives ArgsEncoder

object IamGroupArgs:
  def apply(
    name: Input.Optional[String] = None,
    parentGroupId: Input[Int]
  )(using Context): IamGroupArgs =
    new IamGroupArgs(
      name = name.asOptionOutput(isSecret = false),
      parentGroupId = parentGroupId.asOutput(isSecret = false)
    )
