package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class IamRole private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  description: Output[String],
  grantedRoles: Output[scala.collection.immutable.List[Int]],
  name: Output[String],
  `type`: Output[String]
) extends CustomResource derives ResourceDecoder

object IamRole:
  given outputOps: {} with
    extension(output: Output[IamRole])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def description: Output[String] = output.flatMap(_.description)
      def grantedRoles: Output[scala.collection.immutable.List[Int]] = output.flatMap(_.grantedRoles)
      def name: Output[String] = output.flatMap(_.name)
      def `type`: Output[String] = output.flatMap(_.`type`)

def iamRole(using ctx: Context)(
  name: NonEmptyString,
  args: IamRoleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[IamRole] = 
  ctx.registerResource[IamRole, IamRoleArgs]("akamai:index/iamRole:IamRole", name, args, opts)

