package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class IamRoleArgs private(
  description: Output[String],
  grantedRoles: Output[scala.collection.immutable.List[Int]],
  name: Output[Option[String]],
  `type`: Output[Option[String]]
) derives ArgsEncoder

object IamRoleArgs:
  def apply(
    description: Input[String],
    grantedRoles: Input[List[Input[Int]]],
    name: Input.Optional[String] = None,
    `type`: Input.Optional[String] = None
  )(using Context): IamRoleArgs =
    new IamRoleArgs(
      description = description.asOutput(isSecret = false),
      grantedRoles = grantedRoles.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      `type` = `type`.asOptionOutput(isSecret = false)
    )
