package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class IamUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  address: Output[String],
  authGrantsJson: Output[String],
  city: Output[Option[String]],
  contactType: Output[String],
  country: Output[String],
  email: Output[String],
  emailUpdatePending: Output[Boolean],
  enableTfa: Output[Boolean],
  firstName: Output[String],
  jobTitle: Output[Option[String]],
  lastLogin: Output[String],
  lastName: Output[String],
  lock: Output[Option[Boolean]],
  mobilePhone: Output[Option[String]],
  passwordExpiredAfter: Output[String],
  phone: Output[String],
  preferredLanguage: Output[String],
  secondaryEmail: Output[Option[String]],
  sessionTimeout: Output[Int],
  state: Output[Option[String]],
  tfaConfigured: Output[Boolean],
  timeZone: Output[String],
  userName: Output[String],
  zipCode: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object IamUser:
  given outputOps: {} with
    extension(output: Output[IamUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def address: Output[String] = output.flatMap(_.address)
      def authGrantsJson: Output[String] = output.flatMap(_.authGrantsJson)
      def city: Output[Option[String]] = output.flatMap(_.city)
      def contactType: Output[String] = output.flatMap(_.contactType)
      def country: Output[String] = output.flatMap(_.country)
      def email: Output[String] = output.flatMap(_.email)
      def emailUpdatePending: Output[Boolean] = output.flatMap(_.emailUpdatePending)
      def enableTfa: Output[Boolean] = output.flatMap(_.enableTfa)
      def firstName: Output[String] = output.flatMap(_.firstName)
      def jobTitle: Output[Option[String]] = output.flatMap(_.jobTitle)
      def lastLogin: Output[String] = output.flatMap(_.lastLogin)
      def lastName: Output[String] = output.flatMap(_.lastName)
      def lock: Output[Option[Boolean]] = output.flatMap(_.lock)
      def mobilePhone: Output[Option[String]] = output.flatMap(_.mobilePhone)
      def passwordExpiredAfter: Output[String] = output.flatMap(_.passwordExpiredAfter)
      def phone: Output[String] = output.flatMap(_.phone)
      def preferredLanguage: Output[String] = output.flatMap(_.preferredLanguage)
      def secondaryEmail: Output[Option[String]] = output.flatMap(_.secondaryEmail)
      def sessionTimeout: Output[Int] = output.flatMap(_.sessionTimeout)
      def state: Output[Option[String]] = output.flatMap(_.state)
      def tfaConfigured: Output[Boolean] = output.flatMap(_.tfaConfigured)
      def timeZone: Output[String] = output.flatMap(_.timeZone)
      def userName: Output[String] = output.flatMap(_.userName)
      def zipCode: Output[Option[String]] = output.flatMap(_.zipCode)

def iamUser(using ctx: Context)(
  name: NonEmptyString,
  args: IamUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[IamUser] = 
  ctx.registerResource[IamUser, IamUserArgs]("akamai:index/iamUser:IamUser", name, args, opts)

