package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class IamUserArgs private(
  address: Output[Option[String]],
  authGrantsJson: Output[String],
  city: Output[Option[String]],
  contactType: Output[Option[String]],
  country: Output[String],
  email: Output[String],
  enableTfa: Output[Boolean],
  firstName: Output[String],
  jobTitle: Output[Option[String]],
  lastName: Output[String],
  lock: Output[Option[Boolean]],
  mobilePhone: Output[Option[String]],
  phone: Output[String],
  preferredLanguage: Output[Option[String]],
  secondaryEmail: Output[Option[String]],
  sessionTimeout: Output[Option[Int]],
  state: Output[Option[String]],
  timeZone: Output[Option[String]],
  zipCode: Output[Option[String]]
) derives ArgsEncoder

object IamUserArgs:
  def apply(
    address: Input.Optional[String] = None,
    authGrantsJson: Input[String],
    city: Input.Optional[String] = None,
    contactType: Input.Optional[String] = None,
    country: Input[String],
    email: Input[String],
    enableTfa: Input[Boolean],
    firstName: Input[String],
    jobTitle: Input.Optional[String] = None,
    lastName: Input[String],
    lock: Input.Optional[Boolean] = None,
    mobilePhone: Input.Optional[String] = None,
    phone: Input[String],
    preferredLanguage: Input.Optional[String] = None,
    secondaryEmail: Input.Optional[String] = None,
    sessionTimeout: Input.Optional[Int] = None,
    state: Input.Optional[String] = None,
    timeZone: Input.Optional[String] = None,
    zipCode: Input.Optional[String] = None
  )(using Context): IamUserArgs =
    new IamUserArgs(
      address = address.asOptionOutput(isSecret = false),
      authGrantsJson = authGrantsJson.asOutput(isSecret = false),
      city = city.asOptionOutput(isSecret = false),
      contactType = contactType.asOptionOutput(isSecret = false),
      country = country.asOutput(isSecret = false),
      email = email.asOutput(isSecret = false),
      enableTfa = enableTfa.asOutput(isSecret = false),
      firstName = firstName.asOutput(isSecret = false),
      jobTitle = jobTitle.asOptionOutput(isSecret = false),
      lastName = lastName.asOutput(isSecret = false),
      lock = lock.asOptionOutput(isSecret = false),
      mobilePhone = mobilePhone.asOptionOutput(isSecret = false),
      phone = phone.asOutput(isSecret = false),
      preferredLanguage = preferredLanguage.asOptionOutput(isSecret = false),
      secondaryEmail = secondaryEmail.asOptionOutput(isSecret = false),
      sessionTimeout = sessionTimeout.asOptionOutput(isSecret = false),
      state = state.asOptionOutput(isSecret = false),
      timeZone = timeZone.asOptionOutput(isSecret = false),
      zipCode = zipCode.asOptionOutput(isSecret = false)
    )
