package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ImagingPolicyImage private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  activateOnProduction: Output[Option[Boolean]],
  contractId: Output[String],
  json: Output[String],
  policyId: Output[String],
  policysetId: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object ImagingPolicyImage:
  given outputOps: {} with
    extension(output: Output[ImagingPolicyImage])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def activateOnProduction: Output[Option[Boolean]] = output.flatMap(_.activateOnProduction)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def json: Output[String] = output.flatMap(_.json)
      def policyId: Output[String] = output.flatMap(_.policyId)
      def policysetId: Output[String] = output.flatMap(_.policysetId)
      def version: Output[Int] = output.flatMap(_.version)

def imagingPolicyImage(using ctx: Context)(
  name: NonEmptyString,
  args: ImagingPolicyImageArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ImagingPolicyImage] = 
  ctx.registerResource[ImagingPolicyImage, ImagingPolicyImageArgs]("akamai:index/imagingPolicyImage:ImagingPolicyImage", name, args, opts)

