package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ImagingPolicyImageArgs private(
  activateOnProduction: Output[Option[Boolean]],
  contractId: Output[String],
  json: Output[String],
  policyId: Output[String],
  policysetId: Output[String]
) derives ArgsEncoder

object ImagingPolicyImageArgs:
  def apply(
    activateOnProduction: Input.Optional[Boolean] = None,
    contractId: Input[String],
    json: Input[String],
    policyId: Input[String],
    policysetId: Input[String]
  )(using Context): ImagingPolicyImageArgs =
    new ImagingPolicyImageArgs(
      activateOnProduction = activateOnProduction.asOptionOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      json = json.asOutput(isSecret = false),
      policyId = policyId.asOutput(isSecret = false),
      policysetId = policysetId.asOutput(isSecret = false)
    )
