package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ImagingPolicySet private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[String],
  name: Output[String],
  region: Output[String],
  `type`: Output[String]
) extends CustomResource derives ResourceDecoder

object ImagingPolicySet:
  given outputOps: {} with
    extension(output: Output[ImagingPolicySet])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def name: Output[String] = output.flatMap(_.name)
      def region: Output[String] = output.flatMap(_.region)
      def `type`: Output[String] = output.flatMap(_.`type`)

def imagingPolicySet(using ctx: Context)(
  name: NonEmptyString,
  args: ImagingPolicySetArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ImagingPolicySet] = 
  ctx.registerResource[ImagingPolicySet, ImagingPolicySetArgs]("akamai:index/imagingPolicySet:ImagingPolicySet", name, args, opts)

