package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ImagingPolicySetArgs private(
  contractId: Output[String],
  name: Output[Option[String]],
  region: Output[String],
  `type`: Output[String]
) derives ArgsEncoder

object ImagingPolicySetArgs:
  def apply(
    contractId: Input[String],
    name: Input.Optional[String] = None,
    region: Input[String],
    `type`: Input[String]
  )(using Context): ImagingPolicySetArgs =
    new ImagingPolicySetArgs(
      contractId = contractId.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
