package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class NetworkList private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[Option[String]],
  description: Output[String],
  groupId: Output[Option[Int]],
  lists: Output[Option[scala.collection.immutable.List[String]]],
  mode: Output[String],
  name: Output[String],
  networkListId: Output[String],
  syncPoint: Output[Int],
  `type`: Output[String],
  uniqueid: Output[String]
) extends CustomResource derives ResourceDecoder

object NetworkList:
  given outputOps: {} with
    extension(output: Output[NetworkList])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[Option[String]] = output.flatMap(_.contractId)
      def description: Output[String] = output.flatMap(_.description)
      def groupId: Output[Option[Int]] = output.flatMap(_.groupId)
      def lists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.lists)
      def mode: Output[String] = output.flatMap(_.mode)
      def name: Output[String] = output.flatMap(_.name)
      def networkListId: Output[String] = output.flatMap(_.networkListId)
      def syncPoint: Output[Int] = output.flatMap(_.syncPoint)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def uniqueid: Output[String] = output.flatMap(_.uniqueid)

def networkList(using ctx: Context)(
  name: NonEmptyString,
  args: NetworkListArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[NetworkList] = 
  ctx.registerResource[NetworkList, NetworkListArgs]("akamai:index/networkList:NetworkList", name, args, opts)

