package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class NetworkListActivations private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  network: Output[Option[String]],
  networkListId: Output[String],
  notes: Output[Option[String]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  status: Output[String],
  syncPoint: Output[Int]
) extends CustomResource derives ResourceDecoder

object NetworkListActivations:
  given outputOps: {} with
    extension(output: Output[NetworkListActivations])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def network: Output[Option[String]] = output.flatMap(_.network)
      def networkListId: Output[String] = output.flatMap(_.networkListId)
      def notes: Output[Option[String]] = output.flatMap(_.notes)
      def notificationEmails: Output[scala.collection.immutable.List[String]] = output.flatMap(_.notificationEmails)
      def status: Output[String] = output.flatMap(_.status)
      def syncPoint: Output[Int] = output.flatMap(_.syncPoint)

def networkListActivations(using ctx: Context)(
  name: NonEmptyString,
  args: NetworkListActivationsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[NetworkListActivations] = 
  ctx.registerResource[NetworkListActivations, NetworkListActivationsArgs]("akamai:index/networkListActivations:NetworkListActivations", name, args, opts)

