package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class NetworkListActivationsArgs private(
  network: Output[Option[String]],
  networkListId: Output[String],
  notes: Output[Option[String]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  syncPoint: Output[Int]
) derives ArgsEncoder

object NetworkListActivationsArgs:
  def apply(
    network: Input.Optional[String] = None,
    networkListId: Input[String],
    notes: Input.Optional[String] = None,
    notificationEmails: Input[List[Input[String]]],
    syncPoint: Input[Int]
  )(using Context): NetworkListActivationsArgs =
    new NetworkListActivationsArgs(
      network = network.asOptionOutput(isSecret = false),
      networkListId = networkListId.asOutput(isSecret = false),
      notes = notes.asOptionOutput(isSecret = false),
      notificationEmails = notificationEmails.asOutput(isSecret = false),
      syncPoint = syncPoint.asOutput(isSecret = false)
    )
