package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class NetworkListArgs private(
  contractId: Output[Option[String]],
  description: Output[String],
  groupId: Output[Option[Int]],
  lists: Output[Option[scala.collection.immutable.List[String]]],
  mode: Output[String],
  name: Output[Option[String]],
  `type`: Output[String]
) derives ArgsEncoder

object NetworkListArgs:
  def apply(
    contractId: Input.Optional[String] = None,
    description: Input[String],
    groupId: Input.Optional[Int] = None,
    lists: Input.Optional[List[Input[String]]] = None,
    mode: Input[String],
    name: Input.Optional[String] = None,
    `type`: Input[String]
  )(using Context): NetworkListArgs =
    new NetworkListArgs(
      contractId = contractId.asOptionOutput(isSecret = false),
      description = description.asOutput(isSecret = false),
      groupId = groupId.asOptionOutput(isSecret = false),
      lists = lists.asOptionOutput(isSecret = false),
      mode = mode.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
