package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class NetworkListDescription private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  description: Output[String],
  name: Output[String],
  networkListId: Output[String]
) extends CustomResource derives ResourceDecoder

object NetworkListDescription:
  given outputOps: {} with
    extension(output: Output[NetworkListDescription])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def description: Output[String] = output.flatMap(_.description)
      def name: Output[String] = output.flatMap(_.name)
      def networkListId: Output[String] = output.flatMap(_.networkListId)

def networkListDescription(using ctx: Context)(
  name: NonEmptyString,
  args: NetworkListDescriptionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[NetworkListDescription] = 
  ctx.registerResource[NetworkListDescription, NetworkListDescriptionArgs]("akamai:index/networkListDescription:NetworkListDescription", name, args, opts)

