package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class NetworkListDescriptionArgs private(
  description: Output[String],
  name: Output[Option[String]],
  networkListId: Output[String]
) derives ArgsEncoder

object NetworkListDescriptionArgs:
  def apply(
    description: Input[String],
    name: Input.Optional[String] = None,
    networkListId: Input[String]
  )(using Context): NetworkListDescriptionArgs =
    new NetworkListDescriptionArgs(
      description = description.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      networkListId = networkListId.asOutput(isSecret = false)
    )
