package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class NetworkListSubscription private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  networkLists: Output[scala.collection.immutable.List[String]],
  recipients: Output[scala.collection.immutable.List[String]]
) extends CustomResource derives ResourceDecoder

object NetworkListSubscription:
  given outputOps: {} with
    extension(output: Output[NetworkListSubscription])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def networkLists: Output[scala.collection.immutable.List[String]] = output.flatMap(_.networkLists)
      def recipients: Output[scala.collection.immutable.List[String]] = output.flatMap(_.recipients)

def networkListSubscription(using ctx: Context)(
  name: NonEmptyString,
  args: NetworkListSubscriptionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[NetworkListSubscription] = 
  ctx.registerResource[NetworkListSubscription, NetworkListSubscriptionArgs]("akamai:index/networkListSubscription:NetworkListSubscription", name, args, opts)

